/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Comprobante
extends ObjetoModeloSucesorValidableAnotado<ObjetoModelo>
implements InformacionEditable<Comprobante>,
Importable {
    private static final long serialVersionUID = 2936030347577156870L;
    public static final String C_ESTABLECIMIENTO = "establecimiento";
    public static final String C_PUNTO_EMISION = "puntoEmision";
    public static final String C_SECUENCIAL = "secuencial";
    public static final String C_NUM_AUTORIZACION = "numAutorizacion";
    public static final String C_FECHA_EMISION = "fechaEmision";
    public static final String C_OBLIGATORIO = "obligatorio";
    private static final String VALOR = "El valor ";
    protected static final String MSG_REG_ESTBLM = "El valor Establecimiento debe ser solo n\u00fameros. Diferente de cero. 3 d\u00edgitos. ";
    protected static final String MSG_REG_EMISION = "El valor Punto de emisi\u00f3n debe ser solo n\u00fameros. Diferente de cero. 3 d\u00edgitos. ";
    protected static final String MSG_REG_SECUENCIAL = "El valor Secuencial debe ser solo n\u00fameros. Diferente de cero.  M\u00ednimo 1 d\u00edgito, m\u00e1ximo 9. ";
    protected static final String MSG_REG_AUTORIZACION = "El valor Autorizaci\u00f3n debe ser solo n\u00fameros. Diferente de cero. 3 d\u00edgitos. ";
    protected static final String MSG_REG_DENOMINACION = "El valor Denominaci\u00f3n del r\u00e9gimen fiscal preferente o jurisdicci\u00f3n de menor imposici\u00f3n debe cumplir  M\u00ednimo 2 caracteres, m\u00e1ximo 500. ";
    protected static final String MSG_REG_SEC = "El valor Secuencial debe ser solo n\u00fameros.  M\u00ednimo 1 d\u00edgito, m\u00e1ximo 9. Diferente de cero. ";
    protected static final String MSG_REG_NUMAUT = "El valor No. autorizaci\u00f3n debe ser solo n\u00fameros.  M\u00ednimo 3 d\u00edgitos, m\u00e1ximo 49. Diferente de cero. ";
    private String establecimiento = "000";
    private String puntoEmision = "000";
    private String secuencial = "0";
    private String numAutorizacion = "000";
    @NotNull(message="Debe escoger el valor Fecha emisi\u00f3n")
    private Date fechaEmision = new Date();
    private boolean obligatorio = false;

    public void inicializar() {
        this.fechaEmision = ((Iva)this.getRaizModelo()).periodo.getFechaDeclarada().toDate();
    }

    public void reiniciar() {
        this.setEstablecimiento("000");
        this.setPuntoEmision("000");
        this.setSecuencial("0");
        this.setNumAutorizacion("000");
        this.setFechaEmision(((Iva)this.getRaizModelo()).periodo.getFechaDeclarada().toDate());
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (this.obligatorio) {
            if (this.validarPattern("\\d{3}(?<!000)", this.getEstablecimiento(), MSG_REG_ESTBLM, resultado).esEstadoFallido()) {
                return resultado;
            }
            if (this.validarPattern("\\d{3}(?<!000)", this.getPuntoEmision(), MSG_REG_EMISION, resultado).esEstadoFallido()) {
                return resultado;
            }
            if (this.validarPattern("\\d{1,9}", this.getSecuencial(), MSG_REG_SEC, resultado).esEstadoFallido()) {
                return resultado;
            }
            if (this.validarPattern("\\d{3,49}", this.getNumAutorizacion(), MSG_REG_NUMAUT, resultado).esEstadoFallido()) {
                return resultado;
            }
            if (this.validarSecuencial(resultado).esEstadoFallido()) {
                return resultado;
            }
            if (this.validarNumAutorizacion(resultado).esEstadoFallido()) {
                return resultado;
            }
            if (this.validarFechaEmision(resultado).esEstadoFallido()) {
                return resultado;
            }
        }
        if (!this.validacionExtra(resultado).esEstadoExitoso()) {
            return resultado;
        }
        return resultado.pasarValidacion();
    }

    public Comprobante crearCopiaEdicion() {
        Comprobante copia = new Comprobante();
        copia.setEstablecimiento(this.establecimiento);
        copia.setPuntoEmision(this.puntoEmision);
        copia.setSecuencial(this.secuencial);
        copia.setNumAutorizacion(this.numAutorizacion);
        copia.setFechaEmision(this.fechaEmision);
        copia.setObligatorio(this.obligatorio);
        copia.setPropietario(this.propietario);
        return copia;
    }

    public void actualizarInformacion(Comprobante copiaEdicion) {
        this.setEstablecimiento(copiaEdicion.getEstablecimiento());
        this.setPuntoEmision(copiaEdicion.getPuntoEmision());
        this.setSecuencial(copiaEdicion.getSecuencial());
        this.setNumAutorizacion(copiaEdicion.getNumAutorizacion());
        this.setFechaEmision(copiaEdicion.getFechaEmision());
        this.setObligatorio(copiaEdicion.isObligatorio());
    }

    protected ResultadoValidacion validarFechaEmision(ResultadoValidacion resultado) {
        Iva iva = (Iva)this.getRaizModelo();
        boolean esMicroEmpresa = iva.getDatosDeclaracion().isEsMicroEmpresa();
        if (esMicroEmpresa ? !Util.isFechaMenorIgualPeriodoMesAnio(this.getFechaEmision(), iva.getFechaPeriodoDeclarado()) : !Util.isFechaMenorIgualPeriodoMesAnio(this.getFechaEmision(), iva.getFechaPeriodoDeclarado())) {
            return resultado.fallarValidacion(String.format("La fecha de %s debe ser %s a la fecha del per\u00edodo informado", "emisi\u00f3n", "menor o igual"));
        }
        return resultado;
    }

    protected ResultadoValidacion validacionExtra(ResultadoValidacion resultado) {
        return resultado;
    }

    protected ResultadoValidacion validarSecuencial(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getSecuencial()).compareTo(BigDecimal.ZERO) == 0) {
            return resultado.fallarValidacion(MSG_REG_SEC);
        }
        return resultado;
    }

    protected ResultadoValidacion validarNumAutorizacion(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getNumAutorizacion()).compareTo(BigDecimal.ZERO) == 0) {
            return resultado.fallarValidacion(MSG_REG_NUMAUT);
        }
        return resultado;
    }

    protected ResultadoValidacion validarPattern(String regex, String value, String msg, ResultadoValidacion resultado) {
        if (!Pattern.matches(regex, value)) {
            return resultado.fallarValidacion(msg);
        }
        return resultado;
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName(C_ESTABLECIMIENTO);
        Element eValor = (Element)valorList.item(0);
        this.establecimiento = eValor.getTextContent();
        valorList = elemento.getElementsByTagName(C_PUNTO_EMISION);
        eValor = (Element)valorList.item(0);
        this.puntoEmision = eValor.getTextContent();
        valorList = elemento.getElementsByTagName(C_SECUENCIAL);
        eValor = (Element)valorList.item(0);
        this.secuencial = eValor.getTextContent();
        valorList = elemento.getElementsByTagName("autorizacion");
        eValor = (Element)valorList.item(0);
        this.numAutorizacion = eValor.getTextContent();
        valorList = elemento.getElementsByTagName(C_FECHA_EMISION);
        eValor = (Element)valorList.item(0);
        this.fechaEmision = Util.importarFecha(eValor);
        return this;
    }

    public String getEstablecimiento() {
        return this.establecimiento;
    }

    public String getPuntoEmision() {
        return this.puntoEmision;
    }

    public String getSecuencial() {
        return this.secuencial;
    }

    public Date getFechaEmision() {
        return this.fechaEmision;
    }

    public String getNumAutorizacion() {
        return this.numAutorizacion;
    }

    public boolean isObligatorio() {
        return this.obligatorio;
    }

    public void setEstablecimiento(String establecimiento) {
        String oldValue = this.establecimiento;
        this.establecimiento = establecimiento;
        this.firePropertyChange(C_ESTABLECIMIENTO, oldValue, this.establecimiento);
    }

    public void setPuntoEmision(String puntoEmision) {
        String oldValue = this.puntoEmision;
        this.puntoEmision = puntoEmision;
        this.firePropertyChange(C_PUNTO_EMISION, oldValue, this.puntoEmision);
    }

    public void setSecuencial(String secuencial) {
        String oldValue = this.secuencial;
        this.secuencial = secuencial;
        this.firePropertyChange(C_SECUENCIAL, oldValue, this.secuencial);
    }

    public void setFechaEmision(Date fechaEmision) {
        Date oldValue = this.fechaEmision;
        this.fechaEmision = fechaEmision;
        this.firePropertyChange(C_FECHA_EMISION, oldValue, this.fechaEmision);
    }

    public void setNumAutorizacion(String numAutorizacion) {
        String oldValue = this.numAutorizacion;
        this.numAutorizacion = numAutorizacion;
        this.firePropertyChange(C_NUM_AUTORIZACION, oldValue, this.numAutorizacion);
    }

    public void setObligatorio(boolean obligatorio) {
        boolean oldValue = this.obligatorio;
        this.obligatorio = obligatorio;
        this.firePropertyChange(C_OBLIGATORIO, oldValue, this.obligatorio);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.establecimiento == null ? 0 : this.establecimiento.hashCode());
        result = 31 * result + (this.numAutorizacion == null ? 0 : this.numAutorizacion.hashCode());
        result = 31 * result + (this.puntoEmision == null ? 0 : this.puntoEmision.hashCode());
        result = 31 * result + (this.secuencial == null ? 0 : this.secuencial.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Comprobante)) {
            return false;
        }
        Comprobante other = (Comprobante)((Object)obj);
        if (this.establecimiento == null ? other.establecimiento != null : !this.establecimiento.equals(other.establecimiento)) {
            return false;
        }
        if (this.numAutorizacion == null ? other.numAutorizacion != null : !this.numAutorizacion.equals(other.numAutorizacion)) {
            return false;
        }
        if (this.puntoEmision == null ? other.puntoEmision != null : !this.puntoEmision.equals(other.puntoEmision)) {
            return false;
        }
        return !(this.secuencial == null ? other.secuencial != null : !this.secuencial.equals(other.secuencial));
    }
}

